//EX 7 Program Title:Determine PIV,Vdc,Idc,Vrms,Pdc and Irms for Half Wave Rectifier. 
//environment: Scilab 5.5.2
//Tested on OS: Windows 7 Professional, 64 bit
//Book: Electronics Devices and Circuit Theory  by Robert Boylestead and Nashelsky
/////////////////////////////////////////
clc;
clear all;
close;
xdel(winsid());///clear all the previous figures plots
//////////////////////////////////////////////////////////////////
disp('For Half Wave Rectifier Analysis:' );
RL=input('Enter the value of Load Resistance in Ohms       RL:');//Note:Press enter
Vac=input('Enter the value of Input AC Voltage in Volts     Vac:');//Note:Press enter
N1=input('Enter the Number of primary turns in trun ratio    N1:');//Note:Press enter/
N2=input('Enter the Number of Secondary turns in trun ratio N2:');//Note:Press enter/
mprintf('\n. \********************************************\');
disp('Given data for Half Wave Rectifier is:' );
mprintf(' Load Resistance            RL:%.2f ohm',RL);
mprintf('\n Input AC voltage           V1:%2d V',Vac);
mprintf('\n Number of Secondary turns  N2:%1d ',N2);
mprintf('\n Number of Primary turns    N1:%1d ',N1);
//////////////////Voltage at Secondary//////////////////////////////////
mprintf('\n. \****************Solution****************************\');
V2=Vac*(N2/N1);// Volts RMS secondary voltage
mprintf('\n 1) Voltage at Secondary is V2:%2d',V2);
/////////////////Maximum Value at Secondary //////////////////////////////
mprintf('\n. \********************************************\');
Vm=sqrt(2)*V2; //Volt peak value of Voltage
mprintf('\n 2)Maximum value of secondary voltage is Vm:%2d ',Vm);
mprintf('\n. \********************************************\');
//////////////Load Current//////////////////////////////////
Im=Vm/RL;   // Amperes peak value of current
mprintf('\n 3)Maxi.value of load Current is Im:%1f A',Im);
mprintf('\n. \********************************************\');
//////////////Maximum Load Power//////////////////////////////////
Pmax=(Im^2)*RL;  ///Watts   
mprintf('\n 4)Maximum Load Power is Pmax:%1f W',Pmax);
mprintf('\n. \********************************************\');
Vdc=0.318*Vm;   //Volts  
mprintf('\n 5)Average Value of Output Voltage is Vdc:%1f V',Vdc);
mprintf('\n. \********************************************\');
Idc=Vdc/RL;    //Amperes DC Load current
mprintf('\n 6)Average value of Load current is Idc:%1f A',Idc);
mprintf('\n. \********************************************\');
Pdc=(Idc^2)*RL;    // Watts Average Power
mprintf('\n 7)Average Value Of load Power is Pdc:%1f W',Pdc);
mprintf('\n. \********************************************\');
PIV=Vm;   //Volts  Peak Inverse Voltage
mprintf('\n 8)Peak Inverse Voltage is PIV:%1d V',PIV);
mprintf('\n. \********************************************\');
Vr=Vdc*1.21;   //Volts  Ripple voltage
mprintf('\n 9)Ripple Voltage is Vr:%1f V',Vr);
mprintf('\n. \********************************************\');
Irms=Im/2;    //Amperes RMS Value of Current
mprintf('\n 10)RMS Value of  current is Irms:%1f mA',Irms);
mprintf('\n. \********************************************\');
//output//
 
 //For Half Wave Rectifier Analysis:   
//Enter the value of Load Resistance in Ohms       RL:200
//Enter the value of Input AC Voltage in Volts     Vac:230
//Enter the Number of primary turns in trun ratio    N1:2
//Enter the Number of Secondary turns in trun ratio    N2:1

//. ******************************************** 
// Given data for Half Wave Rectifier is:   
// Load Resistance            RL:200.00 ohm
// Input AC voltage           V1:230 V
// Number of Secondary turns  N2:1 
// Number of Primary turns    N1:2 
//. ****************Solution****************************
//1) Voltage at Secondary is V2:115
//. ********************************************
// 2)Maximum value of secondary voltage is Vm:162 
//. ********************************************
// 3)Maxi.value of load Current is Im:0.813173 A
//. ********************************************
// 4)Maximum Load Power is Pmax:132.250000 W
//. ********************************************
// 5)Average Value of Output Voltage is Vdc:51.717790 V
//. ********************************************
// 6)Average value of Load current is Idc:0.258589 A
//. ********************************************
// 7)Average Value Of load Power is Pdc:13.373649 W
//. ********************************************
// 8)Peak Inverse Voltage is PIV:162 V
//. ********************************************
// 9)Ripple Voltage is Vr:62.578526 V
//. ********************************************
// 10)RMS Value of  current is Irms:0.406586 mA
//. ******************************************** 









